#include <stdio.h>
#include <stdlib.h>
#include <machine/cpufunc.h>
#include <fcntl.h>

extern void
put_midi_message(int c)
{
    while (!(inb(0x32)&1))
           ;
    outb(0x30, c);
}

void
attach_midi_port(void)
{
    int bps = 38400;
    int count = 512/(bps/(300+10));

    if (0>open("/dev/io", O_RDONLY)) {
        perror("open /dev/io");
        exit(1);
    }

    disable_intr();
    /* compatible mode */
    outb(0x138, 0);
    /* all interrupt disable */
    outb(0x35, 0);
    outb(0x34, 0);
    /* stop = 1bit, parity = none, 8bit, x16 */
    outb(0x32, 0x0);
    outb(0x32, 0x0);
    outb(0x32, 0x0);
    outb(0x32, 0x40);
    outb(0x32, 0x4e);
    outb(0x32, 0x35);
    /* timer */
    outb(0x77, 0xb6); /* timer#2, word R/W, mode 2 */
    outb(0x75, count & 0xff);
    outb(0x75, (count>>8)&0xff); /* bps */
    enable_intr();
}


void
reset_all_midi(void)
{
    int port, ch;
    for (port = 2; port > 0; port--) {
        put_midi_message(0xf5);
        put_midi_message(port);
        for (ch=0; ch<16; ch++) {
            /* all sound off */
            put_midi_message(0xb0+ch);
            put_midi_message(120);
            put_midi_message(0);
            /* all reset controller */
            put_midi_message(0xb0+ch);
            put_midi_message(121);
            put_midi_message(0);
            /* all note off */
            put_midi_message(0xb0+ch);
            put_midi_message(122);
            put_midi_message(0);
        }
    }
}

/* end of file */
