#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>

static struct {
	int fd;
	int device;
} port_mapping[256];

static int cur_fd;

void
init_port_mapper()
{
	int i;
	for (i=0; i<256; i++) {
		port_mapping[i].fd = -1;
		port_mapping[i].device = -1;
	}
}

void
parse_port_map(char const *str)
{
	/* p:d,p:d,.... */

	int port, device;
	char *p;

	while (1) {
		port = strtol(str, &p, 0);
		if (*p!=':') {
			fprintf(stderr, "unexpected character.\n");
			exit(1);
		}
		if (str==p) {
			fprintf(stderr, "unexpected void.\n");
			exit(1);
		}
		str = p+1;
		device = strtol(str, &p, 0);
		if (str==p)
			device = -1;
		if (*p!='\0'&&*p!=',') {
			fprintf(stderr, "unexpected character.\n");
			exit(1);
		}

		if (port<0 || port>255) {
			fprintf(stderr, "unexpected port number=%d.\n", port);
			exit(1);
		}
		if (device<-1 || device>255) {
			fprintf(stderr, "unexpected device number=%d.\n",
				port);
			exit(1);
		}

		port_mapping[port].device = device;
		
		if (*p=='\0')
			break;
		str = p+1;
	}
}

void
open_port()
{
	int i;
	char buf[100];

	for (i=0; i<256; i++) {
		if (port_mapping[i].device!=-1) {
			sprintf(buf, "/dev/rmidi%d",
				port_mapping[i].device);
			printf("attach port %d to %s\n", i, buf);
			if ((port_mapping[i].fd=open(buf, O_WRONLY))<0) {
				perror("open");
				exit(1);
			}
		}
	}
	cur_fd = port_mapping[0].fd;
}

void
attach_midi_port(void)
{
	char const *env;
	
	init_port_mapper();
	env = getenv("MIDIPORTS");
	if (env) {
		parse_port_map(env);
	} else {
		parse_port_map("1:0");
	}
	open_port();
}


void
put_midi_message(int c)
{
    char buf;
    static int previous;

    c &= 0xff;
    if (previous == 0xf5) {
	    cur_fd = port_mapping[c].fd;
	    previous = 0;
    } else {
	    if (c!=0xf5) {
		    buf = c;
		    if (cur_fd>=0)
			    write(cur_fd, &buf, 1);
	    }
	    previous = c;
    }
}

void
reset_all_midi(void)
{
    int port, ch;
    for (port = 0; port < 256; port++) {
	if (port_mapping[port].fd>=0) {
            put_midi_message(0xf5);
            put_midi_message(port);
            for (ch=0; ch<16; ch++) {
                /* all sound off */
                put_midi_message(0xb0+ch);
                put_midi_message(120);
                put_midi_message(0);
                /* all reset controller */
                put_midi_message(0xb0+ch);
                put_midi_message(121);
                put_midi_message(0);
                /* all note off */
                put_midi_message(0xb0+ch);
                put_midi_message(122);
                put_midi_message(0);
	    }
        }
    }
}

/* end of file */
