#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>

static int fd;

extern void
put_midi_message(int c)
{
    char buf;
    buf = c;
    write(fd, &buf, 1);
#if 0
{
    static int remain;
    printf("%02X ", c);
    remain++;
    if (remain>=16) {
	printf("\n");
	remain=0;
    }
}
#endif
}

void
attach_midi_port(void)
{
#if 0
    struct termios t;
#endif

    if (0>(fd=open("/dev/rmidi0", O_WRONLY))) {
        perror("open /dev/rmidi0");
        exit(1);
    }
#if 0
    if (0>(fd=open("/dev/cuaa1", O_RDWR))) {
        perror("open /dev/cuaa1");
        exit(1);
    }
    
    if (tcgetattr(fd, &t)) {
        perror("tcgetattr");
        exit(1);
    }
    /* stop = 1bit, parity = none, 8bit, x16 */
    t.c_iflag = IGNBRK | IGNPAR;
    t.c_cflag = CLOCAL | CREAD | CS8;
    t.c_lflag = 0;
    cfsetispeed(&t, B38400);
    cfsetospeed(&t, B38400);
    if (tcsetattr(fd, TCSANOW, &t)) {
        perror("tcsetattr");
        exit(1);
    }
#endif
}


void
reset_all_midi(void)
{
    int port, ch;
    for (port = 2; port > 0; port--) {
        put_midi_message(0xf5);
        put_midi_message(port);
        for (ch=0; ch<16; ch++) {
            /* all sound off */
            put_midi_message(0xb0+ch);
            put_midi_message(120);
            put_midi_message(0);
            /* all reset controller */
            put_midi_message(0xb0+ch);
            put_midi_message(121);
            put_midi_message(0);
            /* all note off */
            put_midi_message(0xb0+ch);
            put_midi_message(122);
            put_midi_message(0);
        }
    }
}

/* end of file */
