#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>

static int fd;

static char buf[4];
static int running_stat;
static int cin;
static int cstate;
static int outport;

extern void
put_midi_message(int c)
{
    int flush = 0;
    int clear = 0;
#if 0
    printf("put : cin=%d, cstate=%d\n", cin, cstate);
#endif
restart:
    switch (cin) {
    case -1:
        /* initial state */
        if ( c<0x80 ) {
            /* running status */
            if ( running_stat<0 ) {
                fprintf(stderr, "error: illegal MIDI packet.\n");
            }
            cin = running_stat>>4;
            buf[0] = cin + ((outport+6)*16);
            buf[1] = running_stat;
            cstate = 2;
            goto restart;
        }
        cin = c>>4;
        if ( 0xf==cin ) {
            switch (c) {
            case 0xf0:
                cin=0x4; /* XXX: exclusive messages are over 4byte, aren't? */
                buf[0] = cin + ((outport+6)*16);
                buf[1] = c;
                cstate = 2;
                break;
            case 0xf1:
            case 0xf3:
                cin=0x2;
                buf[0] = cin + ((outport+6)*16);
                buf[1] = c;
                cstate = 2;
                break;
            case 0xf2:
                cin=0x3;
                buf[0] = cin + ((outport+6)*16);
                buf[1] = c;
                cstate = 2;
                break;
            /*case 0xf4:*/
            case 0xf5:
                cin=0xf5;
                break;
            case 0xf6:
            /*case 0xf7:*/
            case 0xf8:
            case 0xfa:
            case 0xfb:
            case 0xfc:
            case 0xfe:
            case 0xff:
                cin=0x5;
                flush = -1;
                buf[0] = cin + ((outport+6)*16);
                buf[1] = c;
                cstate = 2;
                break;
            default:
                fprintf(stderr, "unknown: packet=0x%02X, cin=%d, cstate=%d\n",
                        c, cin, cstate);
            }
        } else {
            buf[0] = cin + ((outport+6)*16);
            buf[1] = running_stat = c;
            cstate = 2;
        }
        break;
    case 0x2:
    case 0x3:
        buf[cstate++]=c;
        if ( cstate>cin )
            flush = -1;
        break;
    case 0x4:
        /* exclusive messages */
        if ( 0xf7==c ) {
            buf[0] = (cstate+0x4) + ((outport+6)*16);
            buf[cstate] = c;
            flush = -1;
        } else {
            buf[cstate++] = c;
            if ( cstate>3 ) {
                buf[0] = (0x4) + ((outport+6)*16);
                cin = 0xf0;
                flush = -1;
            }
        }
        break;
    case 0x8:
    case 0x9:
    case 0xa:
    case 0xb:
    case 0xc:
    case 0xd:
    case 0xe:
        buf[cstate++] = c;
        if ( cin==0xc || cin==0xd ) {
            flush = -1;
            cin = -1;
        } else if ( cstate>3 ) {
            flush = -1;
            cin = -1;
        }
        break;
    case 0xf0:
        /* continue of exclusive */
        if ( 0xf7==c ) {
            buf[0] = 0x5 + ((outport+6)*16);
            buf[1] = c;
            cin = -1;
            flush = -1;
        } else {
            buf[0] = 0; /* XXX: pending */
            buf[1] = c;
            cin = 4;
            cstate = 2;
        }
        break;
    case 0xf5:
        outport = c-1;
        if ( outport<0 )
          outport = 0;
        clear = -1;
        break;
    }
    if ( flush ) {
        write(fd, buf, 4);
#if 0
            printf("%02X %02X %02X %02X\n",
                   (unsigned char)buf[0], (unsigned char)buf[1],
                   (unsigned char)buf[2], (unsigned char)buf[3]);
#endif
        clear = -1;
    }
    if ( clear ) {
        memset(buf, 0, 4);
#if 0
        printf("cleared:cin=0x%X\n", cin);
#endif
	cstate = -1;
        if ( cin == 0xf0 )
            ;
        else
            cin = -1;
    }
}

void
attach_midi_port(void)
{
    if (0>(fd=open("/dev/ugen0.01", O_WRONLY))) {
        perror("open /dev/ugen0.01");
        exit(1);
    }
    cin = -1;
    cstate = 0;
    running_stat = -1;
    outport = 0;
}


void
reset_all_midi(void)
{
    int port, ch;
    for (port = 2; port > 0; port--) {
        put_midi_message(0xf5);
        put_midi_message(port);
        for (ch=0; ch<16; ch++) {
            /* all sound off */
            put_midi_message(0xb0+ch);
            put_midi_message(120);
            put_midi_message(0);
            /* all reset controller */
            put_midi_message(0xb0+ch);
            put_midi_message(121);
            put_midi_message(0);
            /* all note off */
            put_midi_message(0xb0+ch);
            put_midi_message(122);
            put_midi_message(0);
        }
    }
}

/* end of file */
