#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <termios.h>

int main()
{
    int fd;
    struct termios t;

    char buf[] = { 0x80, 0x40, 0x7f };
    size_t lenBuf = sizeof(buf);

    if (0>(fd = open("/dev/cuaa0", O_WRONLY))) {
        perror("open");
        return -1;
    }

    if (tcgetattr(fd, &t)) {
        perror("tcgetattr");
        return -1;
    }

    t.c_oflag &= ~OPOST;
    t.c_cflag |= CLOCAL | CS8;
    t.c_cflag &= ~(CREAD | CSTOPB | HUPCL | PARENB);
    t.c_lflag |= 0;
    t.c_lflag &= ~(ECHO | ECHOE | ECHOK | ECHONL | ICANON | ISIG
                    | NOFLSH | TOSTOP | IEXTEN);
    cfsetospeed(&t, B38400);

    tcsetattr(fd, TCSANOW, &t);

    write(fd, buf, lenBuf);

    return 0;
}
