#include <stdlib.h>
#include <stdio.h>
#include <machine/cpufunc.h>
#include <fcntl.h>

void outmidi(int c) {
    int s;
    printf("midi = 0x%02x\n", c);
    do {
        s = inb(0x32);
        printf("inb(0x32)=0x%02x\n", s);
    } while (!s & 1);
    outb(0x30, c);
}

int main()
{
    /* int bps = 31250; */
    int bps = 38400;
    int count = 512/(bps/(300+10));

    printf("bps = %d, count = %d\n", bps, count);

    if (0>open("/dev/io", O_RDONLY)) {
        perror("open /dev/io");
        return -1;
    }

    disable_intr();
    /* compatible mode */
    outb(0x138, 0);
    /* all interrupt disable */
    outb(0x35, 0);
    outb(0x34, 0);
    /* stop = 1bit, parity = none, 8bit, x16 */
    outb(0x32, 0x0);
    outb(0x32, 0x0);
    outb(0x32, 0x0);
    outb(0x32, 0x40);
    outb(0x32, 0x4e);
    outb(0x32, 0x35);
    /* timer */
    outb(0x77, 0xb6); /* timer#2, word R/W, mode 2 */
    outb(0x75, count & 0xff);
    outb(0x75, (count>>8)&0xff); /* bps */
    enable_intr();

    outmidi(0xf5);
    outmidi(0x01);  /* 0,1:A, 2:B */
    outmidi(0x90);
    outmidi(0x40);
    outmidi(0x7f);
    outmidi(0xf5);
    outmidi(0x02);  /* 0,1:A, 2:B */
    outmidi(0x90);
    outmidi(0x40);
    outmidi(0x7f);
    outmidi(0xf5);
    outmidi(0x01);  /* 0,1:A, 2:B */

}
